/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package products;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */

//This class is a subclass of Product
public final class WritingPack extends Product {
    //A WritingPack consists of a PencilCase, two Pens, a Pencil, an Eraser
    public PencilCase pencilCase;
    public Pen pen1;
    public Pen pen2;
    public Pencil pencil;
    public Eraser eraser;
    
    public WritingPack (String name) {
        super(name);
    }
    
    @Override
    public void printProduct(){
        //Print out Name, Description and Price
        System.out.println(this);
    }
    
    @Override
    public String toString(){
        return "Name: "+getName()
                +"\nDescription: This Writing Pack consists of the following"
                +"\n\t Pencil case: "+pencilCase.getDescription()
                +"\n\t Pen: "+pen1.getDescription()
                +"\n\t Another Pen: "+pen2.getDescription()
                +"\n\t Pencil: "+pencil.getDescription()
                +"\n\t Eraser: "+eraser.getDescription()
                +"\nPrice: "+getFormattedPrice();
    }
}
